/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.cps.external.mdm.sdk.service.DictMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.DictTypeVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import com.biz.crm.mdm.feign.MdmDictFeign;
import com.biz.crm.nebular.mdm.dict.resp.DictDataRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DictMdmServiceImpl
implements DictMdmService {
    public final String PATH_SPLIT = "/";
    @Autowired
    private MdmDictFeign mdmDictFeign;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<DictTypeVo> findByTypeCodes(List<String> dictTypeCodes) {
        if (CollectionUtils.isEmpty(dictTypeCodes)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dictTypeCodes)) {
            for (String dictTypeCode : dictTypeCodes) {
                DictTypeVo dictTypeVo = new DictTypeVo();
                dictTypeVo.setDictTypeCode(dictTypeCode);
                dictTypeVo.setDictVos(this.findByTypeCode(dictTypeCode));
                list.add(dictTypeVo);
            }
        }
        return list;
    }

    public List<DictVo> findByTypeCode(String dictTypeCode) {
        List<DictDataVo> list;
        if (!StringUtils.isEmpty((String)dictTypeCode) && CollectionUtils.isNotEmpty(list = this.findDictDataByPath(dictTypeCode))) {
            Collection dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, DictDataVo.class, DictVo.class, HashSet.class, ArrayList.class, new String[0]);
            return dictVos.stream().sorted(Comparator.comparing(DictVo::getDictSort)).collect(Collectors.toList());
        }
        return null;
    }

    private List<DictDataVo> findDictDataByPath(String path) {
        DictGroupRedisVo dictGroup;
        ArrayList list = Lists.newArrayList();
        if (!StringUtils.isEmpty((String)path) && (dictGroup = this.findDictGroupByTypeCode(path)) != null) {
            for (DictDataRedisVo item : dictGroup.getDataList()) {
                String path2 = path + "/";
                if (!item.getPath().startsWith(path2)) continue;
                DictDataVo copy = (DictDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
                list.add(copy);
            }
        }
        return list;
    }

    private DictGroupRedisVo findDictGroupByTypeCode(String dictTypeCode) {
        if (!StringUtils.isEmpty((String)dictTypeCode)) {
            Map<Object, Object> dictGroupMap = new HashMap(16);
            Result result = this.mdmDictFeign.getDictGroupRedisList(Collections.singletonList(dictTypeCode));
            if (result == null) {
                return null;
            }
            if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getResult()))) {
                dictGroupMap = ((List)result.getResult()).stream().collect(Collectors.toMap(DictGroupRedisVo::getDictTypeCode, v -> v));
            }
            DictGroupRedisVo group = (DictGroupRedisVo)dictGroupMap.get(dictTypeCode);
            ThreadLocalUtil.addToDictGroup((String)dictTypeCode, (DictGroupRedisVo)group);
            return group;
        }
        return null;
    }
}

