/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.notifier;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.cps.external.mdm.sdk.event.TerminalMdmEventListener;
import com.biz.crm.cps.external.mdm.sdk.vo.RocketMQMessageBody;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalContactMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalSupplyMdmVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="TERMINAL_REFRESH", consumerGroup="TERMINAL_REFRESH${rocketmq.environment-variable}")
public class TerminalRefreshConsumer
implements RocketMQListener<RocketMQMessageBody> {
    private static final Logger log = LoggerFactory.getLogger(TerminalRefreshConsumer.class);
    @Autowired
    private TerminalMdmEventListener terminalMdmEventListener;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public void onMessage(RocketMQMessageBody message) {
        if (null == message) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        String json = JSON.toJSONString((Object)message);
        if (StringUtils.isBlank((CharSequence)message.getId())) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {}", (Object)json);
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = " + json, new String[]{"\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25"});
        }
        try {
            this.handleMessage(message);
        }
        catch (InterruptedException e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
        }
    }

    protected void handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("\u7ec8\u7aef\u4fe1\u606f\u66f4\u65b0\u5f00\u59cb-------------");
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        log.info("\u7ec8\u7aef\u4fe1\u606f\uff1a{}", (Object)msg);
        MdmTerminalVo terminalVo = (MdmTerminalVo)JSON.parseObject((String)msg, MdmTerminalVo.class);
        if (terminalVo == null) {
            log.info("\u7ec8\u7aef\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        TerminalMdmVo terminalMdmVo = this.convertModel(terminalVo);
        terminalMdmVo.setId(null);
        this.terminalMdmEventListener.onChange(null, terminalMdmVo);
        log.info("\u7ec8\u7aef\u4fe1\u606f\u66f4\u65b0\u7ed3\u675f-------------");
    }

    public TerminalMdmVo convertModel(MdmTerminalVo mdmTerminalVo) {
        List supplys;
        log.debug("TerminalMdmVo=={}", (Object)mdmTerminalVo.toString());
        TerminalMdmVo terminalMdmVo = (TerminalMdmVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)mdmTerminalVo, TerminalMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
        List contacts = mdmTerminalVo.getContacts();
        if (!CollectionUtils.isEmpty((Collection)contacts)) {
            ArrayList contactPersonSet = Lists.newArrayList();
            for (MdmTerminalContactVo contact : contacts) {
                TerminalContactMdmVo terminalContactMdmVo = (TerminalContactMdmVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)contact, TerminalContactMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
                contactPersonSet.add(terminalContactMdmVo);
            }
            terminalMdmVo.setContacts((List)contactPersonSet);
        }
        if (!CollectionUtils.isEmpty((Collection)(supplys = mdmTerminalVo.getSupplys()))) {
            ArrayList supplyRelationships = Lists.newArrayList();
            for (MdmTerminalSupplyVo supply : supplys) {
                TerminalSupplyMdmVo terminalSupplyMdmVo = (TerminalSupplyMdmVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)supply, TerminalSupplyMdmVo.class, HashSet.class, LinkedList.class, new String[0]);
                supplyRelationships.add(terminalSupplyMdmVo);
            }
            terminalMdmVo.setSupplys((List)supplyRelationships);
        }
        return terminalMdmVo;
    }
}

