/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.service.NebulaToolkitService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class LoginUserServiceImpl
implements LoginUserService {
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private MdmUserFeign mdmUserFeign;

    public String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            return context.getAuthentication().getName();
        }
        return account;
    }

    public LoginUserDetails getLoginUser() {
        LoginUserDetails loginUserDetails;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && context.getAuthentication() != null && (loginUserDetails = (LoginUserDetails)context.getAuthentication().getDetails()) != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            LoginUserDetails copy = new LoginUserDetails(request);
            BeanUtils.copyProperties((Object)loginUserDetails, (Object)copy);
            return copy;
        }
        return null;
    }

    public String findLoginUserCode() {
        LoginUserDetails loginUser = this.getLoginUser();
        if (loginUser != null && StringUtils.isNotBlank((CharSequence)loginUser.getRealName())) {
            MdmUserReqVo reqVo = new MdmUserReqVo();
            reqVo.setUserName(loginUser.getRealName());
            Result query = this.mdmUserFeign.query(reqVo);
            if (query != null && query.isSuccess() && query.getResult() != null) {
                return ((MdmUserRespVo)query.getResult()).getUserCode();
            }
        }
        return null;
    }
}

