/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.weixinpay.local.service.internal;

import com.biz.crm.cps.external.cash.weixinpay.local.config.WXPayProperties;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.IWXPayDomain;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.WXPayConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXPayConfigServiceImpl
extends WXPayConfig {
    private static final Logger log = LoggerFactory.getLogger(WXPayConfigServiceImpl.class);
    private WXPayProperties wxPayProperties;
    private IWXPayDomain wxPayDomain;

    public WXPayConfigServiceImpl(WXPayProperties wxPayProperties, IWXPayDomain wxPayDomain) {
        this.wxPayProperties = wxPayProperties;
        this.wxPayDomain = wxPayDomain;
    }

    public String getAppID() {
        return this.wxPayProperties.getAppID();
    }

    public String getMchID() {
        return this.wxPayProperties.getMchID();
    }

    public String getKey() {
        return this.wxPayProperties.getKey();
    }

    public InputStream getCertStream() {
        File file = new File(this.wxPayProperties.getCertPath());
        byte[] certData = null;
        try (FileInputStream certStream = new FileInputStream(file);){
            certData = new byte[(int)file.length()];
            ((InputStream)certStream).read(certData);
        }
        catch (FileNotFoundException e) {
            log.error("\u83b7\u53d6\u5546\u6237\u8bc1\u4e66\u5185\u5bb9\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u5546\u6237\u8bc1\u4e66\u5185\u5bb9\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        ByteArrayInputStream certBis = new ByteArrayInputStream(certData);
        return certBis;
    }

    public IWXPayDomain getWXPayDomain() {
        return this.wxPayDomain;
    }
}

