/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.cash.weixinpay.local.service.observer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.cash.sdk.common.enums.CashStatusEnum;
import com.biz.crm.cps.business.cash.sdk.dto.CashConditionDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashConfigurationDto;
import com.biz.crm.cps.business.cash.sdk.dto.CashRecordDto;
import com.biz.crm.cps.business.cash.sdk.service.CashConfigurationVoService;
import com.biz.crm.cps.business.cash.sdk.service.CashRecordVoService;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashMountRegister;
import com.biz.crm.cps.business.cash.sdk.service.observer.CashServiceObserver;
import com.biz.crm.cps.business.cash.sdk.vo.CashProcessVo;
import com.biz.crm.cps.business.cash.sdk.vo.CashRecordVo;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.WXPay;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.WXPayConfig;
import com.biz.crm.cps.external.cash.weixinpay.sdk.utils.WXPayUtil;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="WinXinPayServiceObserverImpl")
public class WinXinPayServiceObserverImpl
implements CashServiceObserver {
    private static final Logger log = LoggerFactory.getLogger(WinXinPayServiceObserverImpl.class);
    @Autowired
    @Qualifier(value="WeiXinPayCashMountRegisterImpl")
    private CashMountRegister cashMountRegister;
    @Autowired(required=false)
    private CashRecordVoService cashRecordVoService;
    @Autowired(required=false)
    private CashConfigurationVoService cashConfigurationVoService;
    @Autowired(required=false)
    private WXPayConfig wxPayConfig;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public CashProcessVo onRequestCashProcess(CashConditionDto cashCondition) {
        if (Objects.isNull(cashCondition) || !Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            return null;
        }
        CashConfigurationDto config = new CashConfigurationDto();
        config.setCashMethodKey(this.cashMountRegister.getKey());
        config.setCashMethodName(this.cashMountRegister.getName());
        config.setSignatoryCode(cashCondition.getPayeeCode());
        config.setSignatoryName(cashCondition.getPayeeName());
        config.setSignatoryType(cashCondition.getParticipatorFlag());
        this.cashConfigurationVoService.create(config);
        CashProcessVo vo = new CashProcessVo();
        vo.setFlag(this.cashMountRegister.getFlag());
        vo.setKey(this.cashMountRegister.getKey());
        vo.setName(this.cashMountRegister.getName());
        vo.setNeedVerify(this.cashMountRegister.needSignVerify());
        vo.setNeedSign(this.cashMountRegister.needSign());
        return vo;
    }

    @Transactional
    public CashProcessVo onCreateContract(CashConditionDto cashCondition) {
        return null;
    }

    @Transactional
    public CashRecordVo onCash(CashConditionDto cashCondition) {
        Validate.notNull((Object)cashCondition, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)cashCondition.getAmount(), (String)"\u5151\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((cashCondition.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5151\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        if (!Objects.equals(cashCondition.getCashKey(), this.cashMountRegister.getKey())) {
            return null;
        }
        CashRecordDto cashRecordDto = new CashRecordDto();
        cashRecordDto.setAmount(cashCondition.getAmount());
        cashRecordDto.setParticipatorCode(cashCondition.getParticipatorCode());
        cashRecordDto.setParticipatorType(cashCondition.getParticipatorFlag());
        cashRecordDto.setParticipatorName(cashCondition.getParticipatorName());
        cashRecordDto.setCashMethodKey(this.cashMountRegister.getKey());
        cashRecordDto.setCashMethodName(this.cashMountRegister.getName());
        cashRecordDto.setCashStatus(CashStatusEnum.PAIDING.getDictCode());
        cashRecordDto.setRewardKey(cashCondition.getRewardKey());
        cashRecordDto.setRewardName(cashCondition.getRewardName());
        cashRecordDto.setPayeeName(cashCondition.getPayeeName());
        cashRecordDto.setPayeePhone(cashCondition.getPayeePhone());
        cashRecordDto.setPayeeCode(cashCondition.getPayeeCode());
        Validate.notBlank((CharSequence)cashCondition.getOpenId(), (String)"\u5151\u4ed8\u65f6\uff0copenid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cashRecordDto.setPayeeBank(cashCondition.getOpenId());
        CashRecordVo cashRecordVo = this.cashRecordVoService.create(cashRecordDto);
        this.pay(cashRecordVo);
        CashRecordDto cashRecordStatus = (CashRecordDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)cashRecordVo, CashRecordDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.cashRecordVoService.updateCashStatus(cashRecordStatus);
        return cashRecordVo;
    }

    private void pay(CashRecordVo cashRecordVo) {
        WXPay wxpay = null;
        try {
            wxpay = new WXPay(this.wxPayConfig);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u652f\u4ed8\u521d\u59cb\u5316\u5931\u8d25\uff01{}", (Object)e, (Object)e.getMessage());
            cashRecordVo.setCashStatus(CashStatusEnum.PAID_FAIL.getDictCode());
            cashRecordVo.setRemark("\u5fae\u4fe1\u652f\u4ed8\u521d\u59cb\u5316\u5931\u8d25!");
            return;
        }
        String nonceStr = WXPayUtil.generateNonceStr();
        int amountFen = cashRecordVo.getAmount().multiply(new BigDecimal(100)).intValue();
        String openid = cashRecordVo.getPayeeBank();
        String cashCode = cashRecordVo.getCashCode();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mch_appid", this.wxPayConfig.getAppID());
        params.put("mchid", this.wxPayConfig.getMchID());
        params.put("nonce_str", nonceStr);
        params.put("partner_trade_no", cashCode);
        params.put("openid", openid);
        params.put("check_name", "NO_CHECK");
        params.put("amount", String.valueOf(amountFen));
        params.put("desc", "\u7ea2\u5305\u63d0\u73b0");
        String sign = null;
        try {
            sign = WXPayUtil.generateSignature(params, (String)this.wxPayConfig.getKey());
            params.put("sign", sign);
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u652f\u4ed8sign\u5931\u8d25\uff01{}" + e.getMessage(), (Throwable)e);
            cashRecordVo.setCashStatus(CashStatusEnum.PAID_FAIL.getDictCode());
            cashRecordVo.setRemark("\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u5931\u8d25!");
            return;
        }
        Map result = null;
        try {
            log.info("\u5fae\u4fe1\u652f\u4ed8\u53c2\u6570=:" + JSON.toJSONString(params));
            String resp = wxpay.requestWithCert("/mmpaymkttransfers/promotion/transfers", params, this.wxPayConfig.getHttpConnectTimeoutMs(), this.wxPayConfig.getHttpReadTimeoutMs());
            result = WXPayUtil.xmlToMap((String)resp);
            log.info("\u5fae\u4fe1\u652f\u4ed8\u7ed3\u679c=:" + JSON.toJSONString((Object)result));
            String returnCode = (String)result.get("return_code");
            String returnMsg = (String)result.get("return_msg");
            String resultCode = (String)result.get("result_code");
            String errCodeDes = (String)result.get("err_code_des");
            if (Objects.equals(returnCode, "SUCCESS") && Objects.equals(resultCode, "SUCCESS")) {
                cashRecordVo.setCashStatus(CashStatusEnum.PAID.getDictCode());
                cashRecordVo.setRemark("\u652f\u4ed8\u6210\u529f!");
            } else {
                cashRecordVo.setCashStatus(CashStatusEnum.PAID_FAIL.getDictCode());
                String remark = Objects.equals(returnMsg, errCodeDes) ? errCodeDes : returnMsg + errCodeDes;
                cashRecordVo.setRemark(remark);
            }
        }
        catch (Exception e) {
            log.error("\u5fae\u4fe1\u652f\u4ed8\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            cashRecordVo.setCashStatus(CashStatusEnum.PAID_FAIL.getDictCode());
            cashRecordVo.setRemark("\u5fae\u4fe1\u652f\u4ed8\u5931\u8d25!");
        }
    }
}

