package com.biz.crm.cps.feign.material.local.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.feign.material.local.feign.MaterialVoFeign;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import feign.hystrix.FallbackFactory;
import java.util.List;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 物料feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/2/22
 */
@Slf4j
@Component
public class MaterialVoFeignImpl implements FallbackFactory<MaterialVoFeign> {
  @Override
  public MaterialVoFeign create(Throwable throwable) {
    return new MaterialVoFeign() {
      @Override
      public Result<Page<MaterialVo>> findByMaterialPageDto(Integer page, Integer size, MaterialPageDto dto) {
        throw new UnsupportedOperationException("获取物料数据分页信息熔断");
      }

      @Override
      public Result<Set<String>> findCodeByProductLevelCodes(Set<String> productLevelCodeSet) {
        throw new UnsupportedOperationException("根据产品层级获取启用的未删除的物料编码集合熔断");
      }

      @Override
      public Result<List<MaterialVo>> findDetailByMaterialCodes(Set<String> materialCodes) {
        throw new UnsupportedOperationException("根据物料编码集合查询详情熔断");
      }

      @Override
      public Result<MaterialVo> findDetailByMaterialCode(String materialCode) {
        throw new UnsupportedOperationException("根据物料编码获取物料信息熔断");
      }
    };
  }
}
