package com.biz.crm.cps.feign.material.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.feign.material.local.feign.MaterialVoFeign;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialDto;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 物料接口实现类
 *
 * @author ning.zhang
 * @date 2022/2/23
 */
@Service("FeignMaterialVoServiceImpl")
public class MaterialVoServiceImpl implements MaterialVoService {

  @Autowired
  private MaterialVoFeign materialVoFeign;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MaterialVo> findByConditions(Pageable pageable, MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public MaterialVo findDetailById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public MaterialVo findDetailByMaterialCode(String materialCode) {
    return this.materialVoFeign.findDetailByMaterialCode(materialCode).getResult();
  }

  @Override
  public List<MaterialVo> findDetailByMaterialCodes(Set<String> materialCodes) {
    return this.materialVoFeign.findDetailByMaterialCodes(materialCodes).getResult();
  }

  @Override
  public void save(MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void update(MaterialDto materialDto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void enableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void disableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Page<MaterialVo> findByMaterialPageDto(Pageable pageable, MaterialPageDto dto) {
    return this.materialVoFeign.findByMaterialPageDto(pageable.getPageNumber(),pageable.getPageSize(),dto).getResult();
  }

  @Override
  public Set<String> findCodeByProductLevelCodes(Set<String> productLevelCodeSet) {
    return this.materialVoFeign.findCodeByProductLevelCodes(productLevelCodeSet).getResult();
  }
}
