package com.biz.crm.business.common.local.config;

import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import com.biz.crm.business.common.local.embedded.MdmServletWebServerFactory;

/**
 * 自定义Web容器配置类，如果需要自定义配置，可以在此类中实现全局配置
 *
 * @author Ken.xu
 * @date 2023-2-14 15:45:40
 */
@Component
public class MdmWebServerEmbeddedFactoryCustomizer implements
    WebServerFactoryCustomizer<AbstractServletWebServerFactory>, Ordered, ApplicationContextAware {
  private Collection<MdmServletWebServerFactory> mdmServletWebServerFactoryList;

  @Override
  public int getOrder() {
    return Ordered.LOWEST_PRECEDENCE;
  }

  /**
   * 获取应用上下文并获取相应的接口实现类
   * 
   * @param applicationContext
   * @throws BeansException
   */
  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    // 根据接口类型返回相应的所有bean
    Map<String, MdmServletWebServerFactory> beansOfType =
        applicationContext.getBeansOfType(MdmServletWebServerFactory.class);
    mdmServletWebServerFactoryList = beansOfType.values();
  }


  @Override
  public void customize(AbstractServletWebServerFactory factory) {
    mdmServletWebServerFactoryList.stream().filter(act -> act.filter(factory))
        .forEach(act -> act.customize(factory));;
  }



}
