package com.biz.crm.business.common.local.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;

/**
 * redis 序列化配置
 * @author phy
 */
@Configuration
@ConditionalOnProperty(name = "redis.protostuff.enabled", havingValue = "true")
public class RedisSerializerConfig {
    /**
     * redis序列化配置
     * @param connectionFactory 连接工厂
     * @return
     */
    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(connectionFactory);
        // 替换默认序列化
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        ProtoStuffRedisSerializer protoStuffRedisSerializer = new ProtoStuffRedisSerializer();
        redisTemplate.setValueSerializer(protoStuffRedisSerializer);
        redisTemplate.setKeySerializer(stringRedisSerializer);
        redisTemplate.setHashKeySerializer(stringRedisSerializer);
        redisTemplate.setHashValueSerializer(protoStuffRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}
