package com.biz.crm.business.common.local.config;

import com.biz.crm.business.common.sdk.service.SignService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;

/**
 * 签名app信息的配置类
 * @Author: Paul Chan
 * @Date: 2020/8/3 11:35
 */
@Configuration
@EnableAutoConfiguration
@EnableConfigurationProperties(SignProperties.class)
public class SignConfiguration {

  @Autowired
  private SignProperties appProperties;

  @PostConstruct
  private void init() {
    Map<String, SignProperties.AppInfo> apps = appProperties.getApps();
    apps.forEach((k, v) -> {
      Validate.notBlank(v.getAppKey(), "appKey not be blank");
      v.setAppId(k);
    });
  }

  @Bean
  public SignService getSignService() {
    return new SignService();
  }

}
