package com.biz.crm.business.common.local.entity;
/**
 * Created by Bao Hongbin on 2021-09-27 17:25.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * @program: crm
 * @description: 带租户编号的树状结构基础实体类
 * @author: Bao Hongbin
 * @create: 2021-09-27 17:25
 **/
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class TenantFlagTreeOpEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 51599617671258350L;

  /**
   * 规则code 查询用
   */
  @TableField(value = "rule_code")
  @Column(name = "rule_code", nullable = false, length = 200, columnDefinition = "varchar(200) COMMENT '规则code '")
  private String ruleCode;

  /**
   * 层级等级 查询用
   */
  @TableField(value = "level_num")
  @Column(name = "level_num", length = 11, columnDefinition = "int(11) COMMENT '层级等级 '")
  private Integer levelNum;
}
