package com.biz.crm.business.common.local.interceptor;
/**
 * Created by Bao Hongbin on 2021-12-02 10:22.
 */

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;

import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

/**
 * @program: crm
 * @description: mybatis基础字段设置拦截器，@Order注解可以指定其执行的顺序，数值越小越晚执行；
 * 本拦截器拦截通过实体进行的创建和更新操作，"强制"设置基础字段，如果有对基础字段手动赋值，则会被该拦截器的值覆盖
 * @author: Bao Hongbin
 * @create: 2021-12-02 10:22
 **/
@Intercepts({@Signature(type = Executor.class, method = "update", args = {MappedStatement.class, Object.class})})
public class DefaultMybatisBaseFieldInterceptor implements Interceptor {

  @Autowired
  private LoginUserService loginUserService;

  @Override
  public Object intercept(Invocation invocation) throws Throwable {
    Object parameter = invocation.getArgs()[1];
    MappedStatement statement = (MappedStatement) invocation.getArgs()[0];
    if (parameter instanceof MapperMethod.ParamMap) {
      Map<? , ?> map = ((Map<? , ?>) parameter);
      if (map.containsKey(Constants.ENTITY) && Objects.nonNull(map.get(Constants.ENTITY))) {
        //通过实体进行更新
        parameter = ((Map<? , ?>) parameter).get(Constants.ENTITY);
      }
    }
    if (parameter instanceof UuidOpEntity) {
      //通过实体进行新增或更新
      UuidOpEntity entity = (UuidOpEntity) parameter;
      AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
      String account = context != null ? context.getAccount() : "admin";
      String username = context != null ? context.getRealName() : "系统管理员或系统定时任务";
      switch (statement.getSqlCommandType()) {
        case INSERT:
          entity.setCreateTime(new Date());
          entity.setCreateName(username);
          entity.setCreateAccount(account);
          entity.setModifyTime(new Date());
          entity.setModifyName(username);
          entity.setModifyAccount(account);
          break;
        case UPDATE:
          entity.setModifyTime(new Date());
          entity.setModifyName(username);
          entity.setModifyAccount(account);
          break;
        default: 
          break;
      }
    }
    return invocation.proceed();
  }

  @Override
  public Object plugin(Object target) {
    if (target instanceof Executor) {
      return Plugin.wrap(target, this);
    }
    return target;
  }

  @Override
  public void setProperties(Properties properties) {

  }
}
