package com.biz.crm.business.common.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 流程业务dto超类：包含了流程编码，流程key，流程状态及备注
 *
 * @author jerry7
 * @date 2022/04/26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class WorkflowFlagOpDto extends TenantFlagOpDto {

  /**
   * 指定发起的流程Key
   */
  @ApiModelProperty("指定发起的流程key")
  private String processKey;

  /**
   * 发起流程标题
   */
  @ApiModelProperty("发起流程标题")
  private String processTitle;

  /**
   * 发起流程备注
   */
  @ApiModelProperty("发起流程备注")
  private String processRemark;

  /**
   * 菜单编码
   */
  @ApiModelProperty("菜单编码")
  private String competenceCode;
}
