package com.biz.crm.business.common.sdk.sensitive;

import java.util.function.Function;

/**
 * 脱敏策略，枚举类，针对不同的数据定制特定的策略
 * @author dy
 * @date 2022/07/07
 */
public enum SensitiveStrategy {

  /**
   * 用户名
   */
  USERNAME(s -> s.replaceAll("(\\S)\\S(\\S*)", "$1*$2")),
  /**
   * 身份证
   */
  ID_CARD(s -> s.replaceAll("(\\d{4})\\d{10}(\\w{4})", "$1****$2")),
  /**
   * 手机号
   */
  PHONE(s -> s.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2")),
  /**
   * 地址
   */
  ADDRESS(s -> s.replaceAll("(\\S{3})\\S{2}(\\S*)\\S{2}", "$1****$2****"));


  private final Function<String, String> desensitizer;

  SensitiveStrategy(Function<String, String> desensitizer) {
    this.desensitizer = desensitizer;
  }

  public Function<String, String> desensitizer() {
    return desensitizer;
  }
}
