package com.biz.crm.business.common.sdk.utils;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 通过地图上的两个坐标计算距离
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class DistanceUtil {

  /**
   * 经纬度转化成弧度
   *
   * @param d 经度/纬度
   * @return 弧度
   */
  private static double rad(double d) {
    return d * Math.PI / 180.0;
  }

  /**
   * 计算两个坐标点之间的距离
   * Add by 成长的小猪（Jason.Song） on 2017/11/01
   * http://blog.csdn.net/jasonsong2008
   *
   * @param firstLatitude   第一个坐标的纬度
   * @param firstLongitude  第一个坐标的经度
   * @param secondLatitude  第二个坐标的纬度
   * @param secondLongitude 第二个坐标的经度
   * @return 返回两点之间的距离，单位：米
   */
  public static double calculatePointDistance(double firstLatitude, double firstLongitude,
                                              double secondLatitude, double secondLongitude) {
    double firstRadLat = rad(firstLatitude);
    double firstRadLng = rad(firstLongitude);
    double secondRadLat = rad(secondLatitude);
    double secondRadLng = rad(secondLongitude);

    double a = firstRadLat - secondRadLat;
    double b = firstRadLng - secondRadLng;
    double cal = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2) + Math.cos(firstRadLat)
        * Math.cos(secondRadLat) * Math.pow(Math.sin(b / 2), 2))) * 6378137;
    return Math.round(cal * 10000d) / 10000d;
  }
}
