package com.biz.crm.business.common.sdk.utils;

import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.common.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * ResponseModel工具类
 * @Author: Paul Chan
 * @Date: 2021/4/14 下午5:21
 */
public class ResponseModelUtils {

  /**
   * 验证成功
   * @param responseModel
   */
  public static void validSuccess(ResponseModel responseModel) {
    validSuccess(responseModel, "操作失败");
  }

  /**
   * 验证成功
   * @param responseModel
   * @param defaultMsg
   */
  public static void validSuccess(ResponseModel responseModel, String defaultMsg) {
    if(StringUtils.isBlank(defaultMsg)) {
      defaultMsg = "操作失败";
    }
    if(responseModel == null || responseModel.getSuccess() == null || !responseModel.getSuccess()) {
      String msg = StringUtils.isBlank(responseModel.getErrorMsg()) ? defaultMsg : responseModel.getErrorMsg();
      throw new RuntimeException(msg);
    }
  }

  /**
   * 验证请求是否成功
   * @param responseModel
   * @return
   */
  public static boolean isSuccess(ResponseModel responseModel){
    if(responseModel == null || responseModel.getSuccess() == null || !responseModel.getSuccess()) {
      return false;
    }
    return true;
  }

  /**
   * 获取成功的数据
   * @param responseModel
   * @return
   */
  public static <T> T getSuccessData(ResponseModel responseModel, Class<T> clazz) {
    if(responseModel == null || responseModel.getSuccess() == null || !responseModel.getSuccess()) {
      return null;
    }
    Object data = responseModel.getData();
    if(data == null) {
      return null;
    }
    return JsonUtils.convert(data, clazz);
  }

  /**
   * 解析并获取ResponseModel报文中的对象列表
   * @param responseModel
   * @param typeReference
   * @param <T>
   * @return
   */
  public static <T> List<T> getList(ResponseModel responseModel, TypeReference<List<T>> typeReference) {
    if(responseModel == null || responseModel.getSuccess() == null || !responseModel.getSuccess()) {
      return Lists.newArrayList();
    }
    Object data = responseModel.getData();
    return JsonUtils.convert(data, typeReference);
  }

}
