package com.biz.crm.business.common.sdk.utils;

import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.Validate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;


/**
 * 本地权限认证的相关工具，目前提供当前登录人信息的获取
 * @Author: Paul Chan，yinwenjie
 * @Date: 2020-04-17 14:13
 */
public final class SecurityUtils {
  /**
   * 匿名用户
   */
  public static final String ANONYMOUS_USER = "anonymousUser";
  
  /**
   * 不允许实例化工具类
   */
  private SecurityUtils() {
    throw new IllegalStateException("静态工具类不允许实例化");
  }

  /**
   * 获取当前系统登录人的代理对象
   * @return
   */
  public static Authentication getAuthentication(){
    if (SecurityContextHolder.getContext() != null &&
        SecurityContextHolder.getContext().getAuthentication() != null) {
      return SecurityContextHolder.getContext().getAuthentication();
    }
    return null;
  }
  
  /**
   * 获取当前系统的登录人账号，返回的是Principal的name属性
   * @return 
   */
  public static String getUserAccount() {
    Validate.notNull(getAuthentication() ,"当前系统未登录用户！");
    Object details = getAuthentication().getDetails();
    Validate.notNull(details , "当前系统未登录用户！");
    if (details instanceof UserIdentity) {
      String account = ((UserIdentity) details).getAccount();
      Validate.notBlank(account , "当前系统未登录用户！");
      Validate.isTrue(!ANONYMOUS_USER.equals(account), "当前系统未登录用户！");
      return account;
    }
    return null;
  }
}