package com.biz.crm.business.common.sdk.utils.wx.open;

import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * 微信小程序第三方接口实现类
 */
public class WxOpenHttpExecuteImpl implements WxOpenHttpExecute {
  private static final Logger LOGGER = LoggerFactory.getLogger(WxOpenHttpExecuteImpl.class);

  @Override
  public <R> R doExecute(Supplier<HttpRequestBase> request,
                         Function<CloseableHttpResponse, R> response) {
    HttpRequestBase httpRequestBase = request.get();
    // TODO: 链接超时时间应该根据应该超时时间设置
    RequestConfig requestConfig = RequestConfig.custom()
            .setConnectionRequestTimeout(12000)
            .setConnectTimeout(12000)
            .setSocketTimeout(12000)
            .build();
    httpRequestBase.setConfig(requestConfig);
    try(CloseableHttpClient build = HttpClientBuilder.create().build();
        CloseableHttpResponse httpResponse = build.execute(httpRequestBase)){
      if (!Objects.equals(httpResponse.getStatusLine().getStatusCode(), 200)){
        throw new HttpResponseException(httpResponse.getStatusLine().getStatusCode(),
                "调用失败，返回状态码: " + httpResponse.getStatusLine().getStatusCode());
      }

      return response.apply(httpResponse);
    } catch (IOException e) {
      LOGGER.error(e.getMessage(), e);
      throw new UncheckedIOException(e);
    }
  }
}
