package com.biz.crm.business.common.sdk.utils.wx.open;

/**
 * 第三方小程序信息类
 */
public class WxOpenInfo {
  /**
   * 小程序的 AppID (授权给第三方开发平台管理的小程序)
   */
  private String authorizerAppid;

  /**
   * 小程序的 AccessToken(授权给第三方开发平台管理的小程序)
   */
  private String authorizerAccessToken;

  /**
   * 第三方平台 appid
   */
  private String componentAppid;

  /**
   * 第三方平台的component_access_token
   */
  private String componentAccessToken;

  /**
   * 缓存剩余过期时间（单位：秒）
   * 注意：微信调用微信api时使用的AccessToken授权给第三方开发平台管理的小程序AccessToken，
   * 但componentAccessToken（开放平台token）与authorizerAccessToken（授权小程序的token）都存在缓存，
   * 所有其中任意一个过期时都需要重新调用内部第三方小程序管理平台的获取最新的AccessToken（开放平台token或授权小程序的token），
   * 故此字段存放的为二者之间缓存剩余时间最短的值，以保证系统中缓存的两个AccessToken均为有效值
   */
  private Integer endTime;

  public String getAuthorizerAppid() {
    return authorizerAppid;
  }

  public void setAuthorizerAppid(String authorizerAppid) {
    this.authorizerAppid = authorizerAppid;
  }

  public String getAuthorizerAccessToken() {
    return authorizerAccessToken;
  }

  public void setAuthorizerAccessToken(String authorizerAccessToken) {
    this.authorizerAccessToken = authorizerAccessToken;
  }

  public String getComponentAppid() {
    return componentAppid;
  }

  public void setComponentAppid(String componentAppid) {
    this.componentAppid = componentAppid;
  }

  public String getComponentAccessToken() {
    return componentAccessToken;
  }

  public void setComponentAccessToken(String componentAccessToken) {
    this.componentAccessToken = componentAccessToken;
  }

  public Integer getEndTime() {
    return endTime;
  }

  public void setEndTime(Integer endTime) {
    this.endTime = endTime;
  }
}
