package com.biz.crm.business.common.sdk.utils.wx.open;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * 微信第三方小程序微信用户相关工具类
 */
public class WxOpenUserProcessor {
  private static final Logger LOGGER = LoggerFactory.getLogger(WxOpenUserProcessor.class);

  private final WxOpenHttpExecute wxOpenHttpExecutor;
  private final WxOpenServiceProvision wxOpenServiceProvision;

  WxOpenUserProcessor(WxOpenServiceProvision wxOpenServiceProvision, WxOpenHttpExecute wxOpenHttpExecutor) {
    this.wxOpenServiceProvision = wxOpenServiceProvision;
    this.wxOpenHttpExecutor = wxOpenHttpExecutor;
  }

  /**
   * 通过JsCode调用微信第三方获取openid，session_key，unionid等信息
   *
   * @param code 前端请求的JsCode码
   * @return
   */
  public WxOpenJscode2SessionResult getSessionInfo(String code) {
    Validate.notBlank(code, "通过JsCode获取微信第三方小程序用户信息时，JsCode不能为空！！！");
    final Supplier<HttpRequestBase> request = () -> {
      WxOpenInfo wxOpenInfo = wxOpenServiceProvision.getWxOpenInfo();
      Validate.notNull(wxOpenInfo, "未找到第三方小程序配置信息！");
      Validate.notNull(wxOpenInfo.getAuthorizerAppid(), "第三方小程序的APPID信息空");
      Validate.notNull(wxOpenInfo.getComponentAppid(), "第三方小程序的第三方APPID信息空");
      Validate.notNull(wxOpenInfo.getComponentAccessToken(), "第三方小程序的第三方AccessToken信息空");

      String url = String.format(WxOpenUrlConstant.WX_OPEN_JSCODE_TO_SEESION_URL,
              wxOpenInfo.getAuthorizerAppid(), code, "authorization_code",
              wxOpenInfo.getComponentAppid(), wxOpenInfo.getComponentAccessToken());
      return new HttpGet(url);
    };
    final Function<CloseableHttpResponse, WxOpenJscode2SessionResult> response = (CloseableHttpResponse httpResponse) -> {
      String responseStr;
      try {
        responseStr = EntityUtils.toString(httpResponse.getEntity());
        Validate.notBlank(responseStr, "微信第三方接口返回数据为空!!!");
      } catch (IOException e) {
        LOGGER.error(e.getMessage(), e);
        throw new UncheckedIOException(e);
      }
      Validate.isTrue(!responseStr.contains("errcode"), "微信用户信息失败：【%s】", responseStr);

      return JSONObject.parseObject(responseStr, WxOpenJscode2SessionResult.class);
    };

    return wxOpenHttpExecutor.doExecute(request, response);
  }
}
