/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.config;

import com.biz.crm.business.common.sdk.model.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result<String> errorHandler(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public Result<String> httpMessageNotReadableExceptionHandler(HttpMessageNotReadableException e) {
        log.error("\u5b57\u6bb5\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        return Result.error("\u5b57\u6bb5\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
    }
}

