package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 带租户编号基础实体类，通过code租户编号进行多租户的数据隔离
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class TenantEntity extends UuidEntity {

  private static final long serialVersionUID = 3635556555396964370L;

  /**
   * 租户编号
   *
   */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = true)
  @TableField(value = "tenant_code")
  @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT '租户编号'")
  private String tenantCode;
}