package com.biz.crm.business.common.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * dto超类：包含了创建人、创建时间、修改人、修改时间
 *
 * @author sunx
 * @date 2021/10/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class UuidOpDto extends UuidDto {

  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", value = "创建人账号")
  private String createAccount;

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 创建人名称
   */
  @ApiModelProperty(name = "createName", value = "创建人名称")
  private String createName;

  /**
   * 更新人账号
   */
  @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
  private String modifyAccount;

  /**
   * 最后更新时间
   */
  @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;

  /**
   * 修改人名称
   */
  @ApiModelProperty(name = "modifyName", value = "修改人名称")
  private String modifyName;
}
