package com.biz.crm.business.common.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @Description:crm数据状态
 * @Author: hefan
 * @Date: 2020/8/20 18:25
 **/
public enum DelFlagStatusEnum {
  /**
   * DELETE
   */
  DELETE("003","删除"),

  /**
   * NORMAL
   */
  NORMAL("009","正常");

  @EnumValue
  @JsonValue
  private String code;

  private String des;

  DelFlagStatusEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * 根据code转枚举
   * @param code
   * @return
   */
  public static DelFlagStatusEnum codeToEnum(String code) {
    DelFlagStatusEnum delFlagStatus = null;
    for (DelFlagStatusEnum enableStatusEnum : DelFlagStatusEnum.values()) {
      if (enableStatusEnum.code.equals(code)) {
        delFlagStatus = enableStatusEnum;
      }
    }
    return delFlagStatus;
  }
}
