package com.biz.crm.business.common.sdk.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashSet;
import java.util.Set;

import com.baomidou.mybatisplus.annotation.EnumValue;
import org.apache.commons.lang3.StringUtils;

/**
 * @Description:crm数据业务状态
 * @Author: hefan
 * @Date: 2020/8/20 18:25
 **/
public enum EnableStatusEnum {
  /**
   * 编码与描述
   */
  DISABLE("003","禁用"),
  ENABLE("009","启用");

  @EnumValue
  @JsonValue
  private String code;
  private String des;

  EnableStatusEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }

  public String getDes() {
    return des;
  }

  /**
   * code转数组
   * @return
   */
  public static Set<String> codeToSet(){
    Set<String> codes = new HashSet<>();
    for (EnableStatusEnum enableStatusEnum : EnableStatusEnum.values()) {
      codes.add(enableStatusEnum.getCode());
    }
    return codes;
  }

  /**
   * 根据code转枚举
   * @param code
   * @return
   */
  public static EnableStatusEnum codeToEnum(String code) {
    EnableStatusEnum enableStatus = null;
    for (EnableStatusEnum enableStatusEnum : EnableStatusEnum.values()) {
        if (enableStatusEnum.code.equals(code)) {
          enableStatus = enableStatusEnum;
        }
    }
    return enableStatus;
  }
  /**
   * 根据code获取文字描述
   * @param code
   * @return
   */
  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      EnableStatusEnum[] values = EnableStatusEnum.values();
      for (EnableStatusEnum value : values) {
        if (value.code.equals(code)) {
          return value.des;
        }
      }
    }
    return null;
  }

  /**
   * 根据code获取相反的状态码
   * @param code
   * @return
   */
  public static String getRevertCode(String code) {
    if (ENABLE.getCode().equals(code)) {
      return DISABLE.getCode();
    } else if (DISABLE.getCode().equals(code)) {
      return ENABLE.getCode();
    }
    return code;
  }

  /**
   * 判断枚举中是否包含该code
   * @param code
   * @return
   */
  public static boolean contains(String code) {
    if (StringUtils.isEmpty(code)) {
      return false;
    }
    EnableStatusEnum[] values = EnableStatusEnum.values();
    for (EnableStatusEnum value : values) {
      if (value.getCode().equals(code)) {
        return true;
      }
    }
    return false;
  }

}

