/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.model;

import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.common.vo.SimpleTenantInfo;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLoginUser
implements LoginDetails,
Serializable {
    private static final long serialVersionUID = -4201160752652020572L;
    private Integer type = null;
    private String tenantCode;
    private String username;
    private String account;
    private String password;
    private String checkCode;
    private String smsVerificationCode;
    private String phone;
    private String sessionId;
    private Integer appType;
    private String realName;
    private String usertype;

    public AbstractLoginUser(HttpServletRequest request) {
        String typeValue = request.getParameter("type");
        if (!StringUtils.isBlank((CharSequence)typeValue) && this.isNumeric(typeValue)) {
            this.type = Integer.parseInt(typeValue);
        }
        this.tenantCode = request.getParameter("tenantCode");
        if (StringUtils.isNotBlank((CharSequence)this.tenantCode)) {
            SimpleTenantInfo simpleTenantInfo = new SimpleTenantInfo(this.tenantCode);
            TenantContextHolder.setTenantInfo((AbstractTenantInfo)simpleTenantInfo);
        }
        this.sessionId = request.getSession().getId();
        this.username = request.getParameter("username");
        this.account = request.getParameter("account");
        this.password = request.getParameter("password");
        this.checkCode = request.getParameter("checkCode");
        this.smsVerificationCode = request.getParameter("smsVerificationCode");
        this.phone = request.getParameter("phone");
        this.usertype = request.getParameter("usertype");
        String appType = request.getParameter("appType");
        if (appType != null) {
            this.appType = Integer.valueOf(appType);
        }
    }

    public AbstractLoginUser(String account, String username, String tenantCode) {
        this.account = account;
        this.username = username;
        this.tenantCode = tenantCode;
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("^[0-9]+$");
        return pattern.matcher(str).find();
    }

    public abstract String getPostCode();

    public abstract String getPostName();

    public Integer getType() {
        return this.type;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAccount() {
        return this.account;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public String getSmsVerificationCode() {
        return this.smsVerificationCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Integer getAppType() {
        return this.appType;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getUsertype() {
        return this.usertype;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public void setSmsVerificationCode(String smsVerificationCode) {
        this.smsVerificationCode = smsVerificationCode;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public void setUsertype(String usertype) {
        this.usertype = usertype;
    }
}

