/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils;

import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.Validate;

public class DateUtils {
    private DateUtils() {
        throw new IllegalStateException("\u9759\u6001\u5de5\u5177\u7c7b\u4e0d\u80fd\u5b9e\u4f8b\u5316");
    }

    public static Date getYesterdayStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return DateUtils.getStartDate(calendar.getTime());
    }

    public static Date getYesterdayEndDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return DateUtils.getEndDate(calendar.getTime());
    }

    public static Date getStartDate(Date date) {
        Validate.notNull((Object)date, (String)"date not be null", (Object[])new Object[0]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndDate(Date date) {
        Validate.notNull((Object)date, (String)"date not be null", (Object[])new Object[0]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Integer getDayInterval(Date start, Date end) {
        LocalDateTime startLocalDateTime = LocalDateTime.ofInstant(start.toInstant(), ZoneId.systemDefault());
        LocalDateTime endLocalDateTime = LocalDateTime.ofInstant(end.toInstant(), ZoneId.systemDefault());
        return Period.between(startLocalDateTime.toLocalDate(), endLocalDateTime.toLocalDate()).getDays();
    }

    public static Date getBeforeByHour(int hour) {
        LocalDateTime date = LocalDateTime.now();
        LocalDateTime localDateTime = date.minusHours(hour);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getBeforeByMinutes(int minutes) {
        LocalDateTime date = LocalDateTime.now();
        LocalDateTime localDateTime = date.minusMinutes(minutes);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

