/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.interceptor;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDatetimeExpr;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.biz.crm.business.common.local.entity.UuidCrmOpEntity;
import com.biz.crm.business.common.local.entity.UuidCrmOpForNumberIdEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.common.repository.interceptor.NebulaRepositoryInterceptorStrategy;
import com.bizunited.nebula.common.repository.interceptor.SqlCommandType;
import java.sql.Connection;
import java.sql.SQLSyntaxErrorException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.stereotype.Component;

@Component
public class DefaultMybatisBaseFieldEnhanceInterceptor
implements NebulaRepositoryInterceptorStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultMybatisBaseFieldEnhanceInterceptor.class);
    private static final String CREATE_TIME = "create_time";
    private static final String CREATE_DATE = "create_date";
    private static final String CREATE_NAME = "create_name";
    private static final String CREATE_ACCOUNT = "create_account";
    private static final String MODIFY_TIME = "modify_time";
    private static final String MODIFY_NAME = "modify_name";
    private static final String MODIFY_ACCOUNT = "modify_account";
    private static final String UPDATE_DATE = "update_date";
    private static final String UPDATE_NAME = "update_name";
    private static final String UPDATE_ACCOUNT = "update_account";
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private JpaProperties jpaProperties;
    @Value(value="${spring.jpa.database}")
    private String databaseType;

    public String intercept(SqlCommandType sqlCommandType, String sql, Connection currentConnection) {
        if (sqlCommandType != SqlCommandType.INSERT && sqlCommandType != SqlCommandType.UPDATE) {
            return sql;
        }
        try {
            switch (sqlCommandType) {
                case INSERT: {
                    return this.handleInsertSql(sql);
                }
                case UPDATE: {
                    return this.handleUpdateSql(sql);
                }
            }
            return sql;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw new IllegalArgumentException(e);
        }
    }

    private String handleUpdateSql(String sql) throws SQLSyntaxErrorException, NoSuchFieldException, IllegalAccessException {
        SQLUpdateStatement sqlUpdateStatement = (SQLUpdateStatement)this.parser(sql, this.databaseType.toLowerCase());
        if (Objects.isNull(sqlUpdateStatement.getTableName())) {
            return sql;
        }
        String tableName = sqlUpdateStatement.getTableName().getSimpleName();
        log.debug("\u83b7\u53d6\u7684\u8868\u540d\u4e3a\uff1a{}", (Object)tableName);
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null) {
            return sql;
        }
        if (!(UuidOpEntity.class.isAssignableFrom(tableInfo.getEntityType()) || UuidCrmOpEntity.class.isAssignableFrom(tableInfo.getEntityType()) || UuidCrmOpForNumberIdEntity.class.isAssignableFrom(tableInfo.getEntityType()))) {
            return sql;
        }
        this.buildUpdateStatement(sqlUpdateStatement);
        return sqlUpdateStatement.toString();
    }

    private void buildUpdateStatement(SQLUpdateStatement sqlUpdateStatement) {
        List items = sqlUpdateStatement.getItems();
        boolean existModifyTime = false;
        boolean existModifyName = false;
        boolean existModifyAccount = false;
        boolean existUpdateDate = false;
        boolean existUpdateName = false;
        boolean existUpdateAccount = false;
        AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
        String account = context != null && StringUtils.isNotBlank((CharSequence)context.getAccount()) ? context.getAccount() : "admin";
        String name = context != null && StringUtils.isNotBlank((CharSequence)context.getRealName()) ? context.getRealName() : "\u7cfb\u7edf\u7528\u6237\u6216\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1";
        String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        for (SQLUpdateSetItem item : items) {
            SQLCharExpr sqlCharExpr;
            SQLExpr value;
            if (item.columnMatch(MODIFY_TIME)) {
                value = item.getValue();
                if (value instanceof SQLNullExpr) {
                    sqlCharExpr = new SQLCharExpr(now);
                    item.setValue((SQLExpr)sqlCharExpr);
                }
                existModifyTime = true;
                continue;
            }
            if (item.columnMatch(MODIFY_NAME)) {
                value = item.getValue();
                if (value instanceof SQLNullExpr) {
                    sqlCharExpr = new SQLCharExpr(name);
                    item.setValue((SQLExpr)sqlCharExpr);
                }
                existModifyName = true;
                continue;
            }
            if (item.columnMatch(MODIFY_ACCOUNT)) {
                value = item.getValue();
                if (value instanceof SQLNullExpr) {
                    sqlCharExpr = new SQLCharExpr(account);
                    item.setValue((SQLExpr)sqlCharExpr);
                }
                existModifyAccount = true;
                continue;
            }
            if (item.columnMatch(UPDATE_DATE)) {
                value = item.getValue();
                if (value instanceof SQLNullExpr) {
                    sqlCharExpr = new SQLCharExpr(now);
                    item.setValue((SQLExpr)sqlCharExpr);
                }
                existUpdateDate = true;
                continue;
            }
            if (item.columnMatch(UPDATE_NAME)) {
                value = item.getValue();
                if (value instanceof SQLNullExpr) {
                    sqlCharExpr = new SQLCharExpr(name);
                    item.setValue((SQLExpr)sqlCharExpr);
                }
                existUpdateName = true;
                continue;
            }
            if (!item.columnMatch(UPDATE_ACCOUNT)) continue;
            value = item.getValue();
            if (value instanceof SQLNullExpr) {
                sqlCharExpr = new SQLCharExpr(account);
                item.setValue((SQLExpr)sqlCharExpr);
            }
            existUpdateAccount = true;
        }
    }

    private String handleInsertSql(String sql) throws SQLSyntaxErrorException, NoSuchFieldException, IllegalAccessException {
        SQLInsertStatement sqlInsertStatement = (SQLInsertStatement)this.parser(sql, this.databaseType.toLowerCase());
        String tableName = sqlInsertStatement.getTableName().getSimpleName();
        log.debug("\u83b7\u53d6\u7684\u8868\u540d\u4e3a\uff1a{}", (Object)tableName);
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null) {
            return sql;
        }
        if (!(UuidOpEntity.class.isAssignableFrom(tableInfo.getEntityType()) || UuidCrmOpEntity.class.isAssignableFrom(tableInfo.getEntityType()) || UuidCrmOpForNumberIdEntity.class.isAssignableFrom(tableInfo.getEntityType()))) {
            return sql;
        }
        SQLSelect query = sqlInsertStatement.getQuery();
        if (Objects.nonNull(query)) {
            return sql;
        }
        List columns = sqlInsertStatement.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return sql;
        }
        this.buildInsertStatement(sqlInsertStatement, columns);
        return sqlInsertStatement.toString();
    }

    private void buildInsertStatement(SQLInsertStatement sqlInsertStatement, List<SQLExpr> columns) {
        boolean existCreateTime = false;
        boolean existCreateData = false;
        boolean existCreateName = false;
        boolean existCreateAccount = false;
        boolean existModifyTime = false;
        boolean existModifyName = false;
        boolean existModifyAccount = false;
        boolean existUpdateDate = false;
        boolean existUpdateName = false;
        boolean existUpdateAccount = false;
        AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
        String account = context != null && StringUtils.isNotBlank((CharSequence)context.getAccount()) ? context.getAccount() : "admin";
        String name = context != null && StringUtils.isNotBlank((CharSequence)context.getRealName()) ? context.getRealName() : "\u7cfb\u7edf\u7528\u6237\u6216\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1";
        List valuesList = sqlInsertStatement.getValuesList();
        block24: for (int i = 0; i < columns.size(); ++i) {
            SQLExpr sqlExpr = columns.get(i);
            switch (sqlExpr.toString()) {
                case "create_date": {
                    this.setInsertExistCreateOrModifyTimeValues(valuesList, i);
                    existCreateData = true;
                    continue block24;
                }
                case "create_time": {
                    this.setInsertExistCreateOrModifyTimeValues(valuesList, i);
                    existCreateTime = true;
                    continue block24;
                }
                case "create_name": {
                    this.setInsertExistCreateOrModifyNameValues(valuesList, name, i);
                    existCreateName = true;
                    continue block24;
                }
                case "create_account": {
                    this.setInsertExistCreateOrModifyAccountValues(valuesList, account, i);
                    existCreateAccount = true;
                    continue block24;
                }
                case "modify_time": {
                    this.setInsertExistCreateOrModifyTimeValues(valuesList, i);
                    existModifyTime = true;
                    continue block24;
                }
                case "modify_name": {
                    this.setInsertExistCreateOrModifyNameValues(valuesList, account, i);
                    existModifyName = true;
                    continue block24;
                }
                case "modify_account": {
                    this.setInsertExistCreateOrModifyAccountValues(valuesList, account, i);
                    existModifyAccount = true;
                    continue block24;
                }
                case "update_date": {
                    this.setInsertExistCreateOrModifyTimeValues(valuesList, i);
                    existUpdateDate = true;
                    continue block24;
                }
                case "update_name": {
                    this.setInsertExistCreateOrModifyNameValues(valuesList, account, i);
                    existUpdateName = true;
                    continue block24;
                }
                case "update_account": {
                    this.setInsertExistCreateOrModifyAccountValues(valuesList, account, i);
                    existUpdateAccount = true;
                }
            }
        }
    }

    private void setInsertCreateOrModifyAccountValues(SQLInsertStatement sqlInsertStatement, List<SQLInsertStatement.ValuesClause> valuesList, boolean existCreateAccount, String account, String createAccount) {
        if (existCreateAccount) {
            return;
        }
        sqlInsertStatement.addColumn((SQLExpr)new SQLIdentifierExpr(createAccount));
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            SQLCharExpr sqlCharExpr = new SQLCharExpr(account);
            values.add(sqlCharExpr);
        }
    }

    private void setInsertCreateOrModifyNameValues(SQLInsertStatement sqlInsertStatement, List<SQLInsertStatement.ValuesClause> valuesList, boolean existCreateName, String name, String createName) {
        if (existCreateName) {
            return;
        }
        sqlInsertStatement.addColumn((SQLExpr)new SQLIdentifierExpr(createName));
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            SQLCharExpr sqlCharExpr = new SQLCharExpr(name);
            values.add(sqlCharExpr);
        }
    }

    private void setInsertExistCreateOrModifyAccountValues(List<SQLInsertStatement.ValuesClause> valuesList, String account, int i) {
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            if (!(values.get(i) instanceof SQLNullExpr)) {
                return;
            }
            SQLCharExpr sqlCharExpr = new SQLCharExpr(account);
            values.set(i, sqlCharExpr);
        }
    }

    private void setInsertCreateOrModifyTimeValues(SQLInsertStatement sqlInsertStatement, List<SQLInsertStatement.ValuesClause> valuesList, boolean existCreateTime, String createTime) {
        if (existCreateTime) {
            return;
        }
        sqlInsertStatement.addColumn((SQLExpr)new SQLIdentifierExpr(createTime));
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            SQLCharExpr sqlExpr = null;
            String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
            if (this.jpaProperties.getDatabase() == Database.ORACLE) {
                SQLCharExpr nowExpr = new SQLCharExpr(now);
                SQLCharExpr formatExpr = new SQLCharExpr("yyyy-MM-dd HH24:mi:ss");
                sqlExpr = new OracleDatetimeExpr((SQLExpr)nowExpr, (SQLExpr)formatExpr);
            } else if (this.jpaProperties.getDatabase() == Database.ORACLE) {
                ArrayList<SQLCharExpr> params = new ArrayList<SQLCharExpr>();
                params.add(new SQLCharExpr(now));
                params.add(new SQLCharExpr("yyyy-MM-dd HH24:mi:ss"));
                sqlExpr = new SQLMethodInvokeExpr("to_date", null, params);
            } else {
                sqlExpr = new SQLCharExpr(now);
            }
            values.add(sqlExpr);
        }
    }

    private void setInsertExistCreateOrModifyNameValues(List<SQLInsertStatement.ValuesClause> valuesList, String name, int i) {
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            if (!(values.get(i) instanceof SQLNullExpr)) {
                return;
            }
            SQLCharExpr sqlCharExpr = new SQLCharExpr(name);
            values.set(i, sqlCharExpr);
        }
    }

    private void setInsertExistCreateOrModifyTimeValues(List<SQLInsertStatement.ValuesClause> valuesList, int i) {
        for (SQLInsertStatement.ValuesClause valuesClause : valuesList) {
            List values = valuesClause.getValues();
            if (!(values.get(i) instanceof SQLNullExpr)) {
                return;
            }
            SQLCharExpr sqlExpr = null;
            String now = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
            if (this.jpaProperties.getDatabase() == Database.ORACLE) {
                SQLCharExpr nowExpr = new SQLCharExpr(now);
                SQLCharExpr formatExpr = new SQLCharExpr("yyyy-MM-dd HH24:mi:ss");
                sqlExpr = new OracleDatetimeExpr((SQLExpr)nowExpr, (SQLExpr)formatExpr);
            } else {
                sqlExpr = new SQLCharExpr(now);
            }
            values.set(i, sqlExpr);
        }
    }

    public SQLStatement parser(String sql, String dbType) throws SQLSyntaxErrorException {
        List list = SQLUtils.parseStatements((String)sql, (String)dbType);
        if (list.size() > 1) {
            throw new SQLSyntaxErrorException("MultiQueries is not supported,use single query instead ");
        }
        return (SQLStatement)list.get(0);
    }

    public int sort() {
        return 2;
    }
}

