/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.service.internal;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.service.EmailService;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DefaultEmailServiceImpl
implements EmailService {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailServiceImpl.class);
    @Autowired(required=false)
    private JavaMailSender mailSender;
    @Autowired
    private FileHandleService fileHandleService;
    @Value(value="${spring.mail.username:null}")
    private String defaultFrom;

    @Override
    public void sendMail(String from, String[] to, String[] cc, String subject, String content, Collection<FileDto> files) {
        try {
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.name());
            if (StringUtils.isBlank((CharSequence)from)) {
                from = this.defaultFrom;
            }
            messageHelper.setFrom(from);
            messageHelper.setTo(to);
            String[] c = new String[]{};
            if (Objects.isNull(cc)) {
                messageHelper.setCc(c);
            } else {
                messageHelper.setCc(cc);
            }
            messageHelper.setSubject(subject);
            messageHelper.setText(content);
            if (!CollectionUtils.isEmpty(files)) {
                files.forEach(item -> {
                    OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(item.getFileCode());
                    byte[] fileBytes = this.fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(), ordinaryFileVo.getFileName());
                    try {
                        messageHelper.addAttachment(ordinaryFileVo.getOriginalFileName(), (InputStreamSource)new ByteArrayResource(fileBytes));
                    }
                    catch (MessagingException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u90ae\u4ef6\u53d1\u9001\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u90ae\u4ef6\u53d1\u9001\u670d\u52a1\u5668\u914d\u7f6e", e);
        }
    }
}

