/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DefaultLoginUserServiceImpl
implements LoginUserService {
    @Autowired(required=false)
    private List<AuthenticationRefreshStrategy> authenticationRefreshStrategies;

    public Authentication getAuthentication() {
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            return SecurityContextHolder.getContext().getAuthentication();
        }
        return null;
    }

    public String getLoginAccountName() {
        if (this.getAuthentication() == null) {
            return null;
        }
        return this.getAuthentication().getName();
    }

    public UserIdentity getLoginUser() {
        if (this.getAuthentication() == null) {
            return null;
        }
        Object details = this.getAuthentication().getDetails();
        if (details == null) {
            return null;
        }
        if (details instanceof UserIdentity) {
            return (UserIdentity)details;
        }
        return null;
    }

    @Override
    public AbstractCrmUserIdentity getAbstractLoginUser() {
        UserIdentity loginUser = this.getLoginUser();
        if (loginUser instanceof AbstractCrmUserIdentity) {
            return (AbstractCrmUserIdentity)loginUser;
        }
        return null;
    }

    @Override
    public JSONObject getLoginUserJson() {
        UserIdentity loginUser = this.getLoginUser();
        return JsonUtils.toJSONObject((Object)loginUser);
    }

    public <T extends UserIdentity> T getLoginDetails(Class<T> targetClass) {
        if (this.getAuthentication() == null) {
            return null;
        }
        Object details = this.getAuthentication().getDetails();
        UserIdentity targetObject = null;
        if (details instanceof UserIdentity) {
            targetObject = (UserIdentity)details;
        }
        return (T)targetObject;
    }

    public String findCurrentAccount() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return "admin";
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return "admin";
        }
        return authentication.getName();
    }

    public Authentication refreshAuthentication(Object userInfo) {
        if (CollectionUtils.isEmpty(this.authenticationRefreshStrategies)) {
            return null;
        }
        for (AuthenticationRefreshStrategy authenticationRefreshStrategy : this.authenticationRefreshStrategies) {
            if (!authenticationRefreshStrategy.matched(userInfo)) continue;
            UserIdentity userIdentity = authenticationRefreshStrategy.refresh(userInfo);
            if (userIdentity == null) {
                return null;
            }
            ArrayList grantedAuthorities = Lists.newArrayList();
            String[] roleCodes = userIdentity.getRoleCodes();
            if (roleCodes != null && roleCodes.length > 0) {
                for (String roleCode : roleCodes) {
                    grantedAuthorities.add(new SimpleGrantedAuthority(roleCode));
                }
            }
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userIdentity.getAccount(), (Object)"123456", (Collection)grantedAuthorities);
            authentication.setDetails((Object)userIdentity);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            return authentication;
        }
        return null;
    }
}

