package com.biz.crm.business.common.local.config;

import com.biz.crm.business.common.sdk.model.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author jerry7
 * @date 2021/11/4 9:45
 * 初步的全局异常捕获，后续完善
 */
@ControllerAdvice
@Slf4j
public class GlobalExceptionHandler {

    @ExceptionHandler(value = Exception.class)
    @ResponseBody
    public Result<String> errorHandler(Exception e) {
        log.error(e.getMessage(), e);
        //拦截器已打印错误日志
        return Result.error(e.getMessage());
    }

    @ExceptionHandler(value = HttpMessageNotReadableException.class)
    @ResponseBody
    public Result<String> httpMessageNotReadableExceptionHandler(HttpMessageNotReadableException e) {
        //拦截器已打印错误日志
        log.error("字段类型转换异常", e);
        return Result.error("字段类型转换异常");
    }
}
