package com.biz.crm.business.common.local.config;
/**
 * Created by Bao Hongbin on 2021-12-02 10:25.
 */

import com.baomidou.mybatisplus.extension.incrementer.OracleKeyGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.biz.crm.business.common.local.interceptor.DefaultMybatisBaseFieldInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @program: crm
 * @description: mybatis配置
 * @author: Bao Hongbin
 * @create: 2021-12-02 10:25
 **/
@Configuration
public class MybatisConfig {
    /**
     * 设置mybatis拦截器，可设置多个拦截器，通过@Order注解排序
     * 默认注入DefaultMybatisBaseFieldInterceptor，实现对继承UuidOpEntity类的基础字段设值
     * 该拦截器只会拦截通过实体进行的新增和修改操作，并对基础字段强制性赋值
     *
     * @return
     */
    @Bean
    public Interceptor DefaultMybatisBaseFieldInterceptor() {
        return new DefaultMybatisBaseFieldInterceptor();
    }

    /*
     * 使用nebula-mars提供的拦截策略处理器
     * */

    /**
     * 分页插件配置
     *
     * @return
     */
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor());
        return interceptor;
    }

    @Bean
    public OracleKeyGenerator oracleKeyGenerator() {
        return new OracleKeyGenerator();
    }
}
