package com.biz.crm.business.common.local.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

/**
 * 为 Redis 消息监听器提供异步行为的容器
 * Redis消息侦听器容器 与 RegistrarServerMsgHandler中继承的KeyExpirationEventMessageListener类相关
 * 继承KeyExpirationEventMessageListener的类需要创建一个参数为RedisMessageListenerContainer的构造函数
 * 配合使用，实现对key键的失效监听检测并进行逻辑处理。
 *
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年05月13日 19:58:00
 */
@Configuration
public class RedisListenerConfig {

    @Bean
    public RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(connectionFactory);
        return redisMessageListenerContainer;
    }

}
