package com.biz.crm.business.common.local.embedded.impl;

import com.biz.crm.business.common.local.embedded.MdmServletWebServerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.stereotype.Service;

/**
 * 自定义Tomcat容器配置类
 *
 * @author ning.zhang
 * @date 2022/10/27
 */
@Service
public class MdmTomcatWebServerFactoryCustomizer
        implements MdmServletWebServerFactory<TomcatServletWebServerFactory> {

    private static final int DEFAULT_MAX_PARAMETER_COUNT = 10000;

    /**
     * 单次请求参数最大限制数
     */
    @Value("${server.tomcat.maxParameterCount:10000}")
    private int maxParameterCount = DEFAULT_MAX_PARAMETER_COUNT;

    @Override
    public boolean filter(AbstractServletWebServerFactory factory) {
        return factory instanceof TomcatServletWebServerFactory;
    }

    @Override
    public void customize(TomcatServletWebServerFactory factory) {
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(maxParameterCount)
                .when(maxParameterCount -> maxParameterCount != DEFAULT_MAX_PARAMETER_COUNT)
                .to(maxParameterCount -> factory.addConnectorCustomizers(
                        connector -> connector.setMaxParameterCount(maxParameterCount)));
    }

}


