package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * @author Administrator
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class FileEntity extends TenantEntity {
  private static final long serialVersionUID = 3739789099248000982L;

  /**
   * 文件唯一识别号
   */
  @ApiModelProperty(value = "文件唯一识别号")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 36, columnDefinition = "VARCHAR2(36) ")
  private String fileCode;

  /**
   * 原始文件名
   */
  @ApiModelProperty(name="originalFileName" , value="原始文件名")
  @TableField(value = "original_name")
  @Column(name = "original_name", nullable = true, columnDefinition = "VARCHAR2(255)")
  private String originalFileName;

  /**
   * 文件全路径url
   */
  @ApiModelProperty(name="fullUrl" , value="文件全路径url")
  @TableField(value = "full_url")
  @Column(name = "full_url", columnDefinition = "VARCHAR2(500)")
  private String fullUrl;
}