package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 在实际建模过程中，我们发现很多模型都需要类似创建人、创建时间、修改人、修改时间这样的设定<br>
 * 为了同时满足多个模型上这样的需求，我们将这部分属性专门提取出来形成UuidOpEntity上层抽象类
 *
 * @author yinwenjie
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class UuidCrmOpForNumberIdEntity implements Serializable {

    private static final long serialVersionUID = 5653872998261742660L;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "sequenceGenerator")
    @Column(name = "id")
    private Long id;
    /**
     * 创建时间
     */
    @TableField(value = "create_date", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "create_date", columnDefinition = "DATE")
    private Date createDate;

    /**
     * 创建人账号
     */
    @TableField(value = "create_account", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_account", columnDefinition = "VARCHAR2(60)")
    private String createAccount;

    /**
     * 创建人名称
     */
    @TableField(value = "create_name", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "create_name", columnDefinition = "VARCHAR2(128)")
    private String createName;

    /**
     * 修改时间
     */
    @TableField(value = "update_date", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "update_date", columnDefinition = "DATE")
    private Date updateDate;

    /**
     * 修改人账号
     */
    @TableField(value = "update_account", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_account", columnDefinition = "VARCHAR2(60)")
    private String updateAccount;

    /**
     * 修改人名称
     */
    @TableField(value = "update_name", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "update_name", columnDefinition = "VARCHAR2(128)")
    private String updateName;

    public void setUpdateInfoToNull() {
        this.updateDate = null;
        this.updateAccount = null;
        this.updateName = null;
    }

    public void setCreateInfoNull() {
        this.createDate = null;
        this.createAccount = null;
        this.createName = null;
    }

    public void setAllInfoNull() {
        setCreateInfoNull();
        setUpdateInfoToNull();
    }

}