package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

/**
 * 标识字段
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class UuidFlagOpEntity extends UuidOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = -3799529180545896952L;

  /**
   * 数据状态（删除状态）
   */
  @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY, jdbcType = VARCHAR)
  @Field(type = FieldType.Keyword)
  @Column(name = "del_flag", nullable = true, length = 10, columnDefinition = "VARCHAR2(10)")
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY, jdbcType = VARCHAR)
  @Field(type = FieldType.Keyword)
  @Column(name = "enable_status", nullable = true, length = 10, columnDefinition = "VARCHAR2(10)")
  private String enableStatus;

  /**
   * 备注
   */
  @TableField(value = "remark", jdbcType = VARCHAR)
  @Field(type = FieldType.Text)
  @Column(name = "remark", nullable = true, length = 400, columnDefinition = "VARCHAR2(400)")
  private String remark;
}
