package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.util.Date;

/**
 * 在实际建模过程中，我们发现很多模型都需要类似创建人、创建时间、修改人、修改时间这样的设定<br>
 * 为了同时满足多个模型上这样的需求，我们将这部分属性专门提取出来形成UuidOpEntity上层抽象类
 * @author yinwenjie
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class UuidOpEntity extends UuidEntity {

    /**
     *
     */
    private static final long serialVersionUID = 405775619447374067L;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Field(type = FieldType.Date)
    @Column(name = "create_time" , length = 20, columnDefinition = "DATE")
    private Date createTime;

    /**
     * 创建人账号
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Field(type = FieldType.Keyword)
    @Column(name = "create_account" , length = 60, columnDefinition = "VARCHAR2(60)")
    private String createAccount;

    /**
     * 创建人名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Field(type = FieldType.Keyword)
    @Column(name = "create_name" , length = 60, columnDefinition = "VARCHAR2(60)")
    private String createName;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Field(type = FieldType.Date)
    @Column(name = "modify_time" , length = 20, columnDefinition = "DATE")
    private Date modifyTime;

    /**
     * 修改人账号
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Field(type = FieldType.Keyword)
    @Column(name = "modify_account" , length = 60, columnDefinition = "VARCHAR2(40)")
    private String modifyAccount;

    /**
     * 修改人名称
     */
    @TableField(fill = FieldFill.UPDATE,updateStrategy = FieldStrategy.NOT_EMPTY)
    @Field(type = FieldType.Keyword)
    @Column(name = "modify_name" , length = 60, columnDefinition = "VARCHAR2(60)")
    private String modifyName;


    public void setModifyInfoToNull(){
        this.modifyTime = null;
        this.modifyAccount = null;
        this.modifyName = null;
    }

    public void setCreateInfoNull(){
        this.createTime = null;
        this.createAccount = null;
        this.createName = null;
    }

    public void setAllInfoNull(){
        setCreateInfoNull();
        setModifyInfoToNull();
    }

}