package com.biz.crm.business.common.local.interceptor;
/**
 * Created by Bao Hongbin on 2021-12-02 10:22.
 */

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.biz.crm.business.common.local.entity.*;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.*;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

/**
 * @program: crm
 * @description: mybatis基础字段设置拦截器，@Order注解可以指定其执行的顺序，数值越小越晚执行；
 * 本拦截器拦截通过实体进行的创建和更新操作，"强制"设置基础字段，如果有对基础字段手动赋值，则会被该拦截器的值覆盖
 * @author: Bao Hongbin
 * @create: 2021-12-02 10:22
 **/
@Intercepts({@Signature(type = Executor.class, method = "update", args = {MappedStatement.class, Object.class})})
public class DefaultMybatisBaseFieldInterceptor implements Interceptor {

    @Autowired
    private LoginUserService loginUserService;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Object parameter = invocation.getArgs()[1];
        MappedStatement statement = (MappedStatement) invocation.getArgs()[0];
        if (parameter instanceof MapperMethod.ParamMap) {
            Map<?, ?> map = ((Map<?, ?>) parameter);
            if (map.containsKey(Constants.ENTITY) && Objects.nonNull(map.get(Constants.ENTITY))) {
                //通过实体进行更新
                parameter = ((Map<?, ?>) parameter).get(Constants.ENTITY);
            }
        }
        AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
        String account = context != null && StringUtils.isNotEmpty(context.getAccount()) ? context.getAccount() : "admin";
        String realName = context != null && StringUtils.isNotEmpty(context.getRealName()) ? context.getRealName() : "系统管理员或系统定时任务";
        if (parameter instanceof UuidOpEntity) {
            //通过实体进行新增或更新
            UuidOpEntity entity = (UuidOpEntity) parameter;
            switch (statement.getSqlCommandType()) {
                case INSERT:
                    if (Objects.isNull(entity.getCreateTime())) {
                        entity.setCreateTime(new Date());
                    }
                    if (StringUtils.isBlank(entity.getCreateAccount())) {
                        entity.setCreateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getCreateName())) {
                        entity.setCreateName(realName);
                    }
                    if (Objects.isNull(entity.getModifyTime())) {
                        entity.setModifyTime(new Date());
                    }
                    if (StringUtils.isBlank(entity.getModifyAccount())) {
                        entity.setModifyAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getModifyName())) {
                        entity.setModifyName(realName);
                    }
                    break;
                case UPDATE:
                    if (Objects.isNull(entity.getModifyTime())) {
                        entity.setModifyTime(new Date());
                    }
                    if (StringUtils.isBlank(entity.getModifyAccount())) {
                        entity.setModifyAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getModifyName())) {
                        entity.setModifyName(realName);
                    }
                    break;
                default:
                    break;
            }
        }
        if (parameter instanceof com.bizunited.nebula.common.entity.UuidOpEntity) {
            //通过实体进行新增或更新
            com.bizunited.nebula.common.entity.UuidOpEntity entity = (com.bizunited.nebula.common.entity.UuidOpEntity) parameter;
            switch (statement.getSqlCommandType()) {
                case INSERT:
                    if (Objects.isNull(entity.getCreateTime())) {
                        entity.setCreateTime(new Date());
                    }
                    if (StringUtils.isBlank(entity.getCreateAccount())) {
                        entity.setCreateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getCreateName())) {
                        entity.setCreateName(realName);
                    }
                    if (Objects.isNull(entity.getModifyTime())) {
                        entity.setModifyTime(new Date());
                    }
                    if (StringUtils.isBlank(entity.getModifyAccount())) {
                        entity.setModifyAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getModifyName())) {
                        entity.setModifyName(realName);
                    }
                    break;
                case UPDATE:
                    if (Objects.isNull(entity.getModifyTime())) {
                        entity.setModifyTime(new Date());
                    }
                    if (StringUtils.isBlank(entity.getModifyAccount())) {
                        entity.setModifyAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getModifyName())) {
                        entity.setModifyName(realName);
                    }
                    break;
                default:
                    break;
            }
        }
        if (parameter instanceof UuidCrmOpEntity) {
            //通过实体进行新增或更新
            UuidCrmOpEntity entity = (UuidCrmOpEntity) parameter;
            switch (statement.getSqlCommandType()) {
                case INSERT:
                    if (Objects.isNull(entity.getCreateDate())) {
                        entity.setCreateDate(new Date());
                    }
                    if (StringUtils.isBlank(entity.getCreateAccount())) {
                        entity.setCreateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getCreateName())) {
                        entity.setCreateName(realName);
                    }
                    if (Objects.isNull(entity.getUpdateDate())) {
                        entity.setUpdateDate(new Date());
                    }
                    if (StringUtils.isBlank(entity.getUpdateAccount())) {
                        entity.setUpdateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getUpdateName())) {
                        entity.setUpdateName(realName);
                    }
                    break;
                case UPDATE:
                    if (Objects.isNull(entity.getUpdateDate())) {
                        entity.setUpdateDate(new Date());
                    }
                    if (StringUtils.isBlank(entity.getUpdateAccount())) {
                        entity.setUpdateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getUpdateName())) {
                        entity.setUpdateName(realName);
                    }
                    break;
                default:
                    break;
            }
        }
        if (parameter instanceof UuidCrmOpForNumberIdEntity) {
            //通过实体进行新增或更新
            UuidCrmOpForNumberIdEntity entity = (UuidCrmOpForNumberIdEntity) parameter;
            switch (statement.getSqlCommandType()) {
                case INSERT:
                    if (Objects.isNull(entity.getCreateDate())) {
                        entity.setCreateDate(new Date());
                    }
                    if (StringUtils.isBlank(entity.getCreateAccount())) {
                        entity.setCreateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getCreateName())) {
                        entity.setCreateName(realName);
                    }
                    if (Objects.isNull(entity.getUpdateDate())) {
                        entity.setUpdateDate(new Date());
                    }
                    if (StringUtils.isBlank(entity.getUpdateAccount())) {
                        entity.setUpdateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getUpdateName())) {
                        entity.setUpdateName(realName);
                    }
                    break;
                case UPDATE:
                    if (Objects.isNull(entity.getUpdateDate())) {
                        entity.setUpdateDate(new Date());
                    }
                    if (StringUtils.isBlank(entity.getUpdateAccount())) {
                        entity.setUpdateAccount(account);
                    }
                    if (StringUtils.isBlank(entity.getUpdateName())) {
                        entity.setUpdateName(realName);
                    }
                    break;
                default:
                    break;
            }
        }
        if (parameter instanceof UuidFlagOpEntity) {
            UuidFlagOpEntity entity = (UuidFlagOpEntity) parameter;
            if (SqlCommandType.INSERT.equals(statement.getSqlCommandType())) {
                if (Objects.isNull(entity.getDelFlag())) {
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                }
                if (Objects.isNull(entity.getEnableStatus())) {
                    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                }
            }
        }
        if (parameter instanceof TenantOpEntity) {
            TenantOpEntity entity = (TenantOpEntity) parameter;
            if (SqlCommandType.INSERT.equals(statement.getSqlCommandType())) {
                if (Objects.isNull(entity.getTenantCode())) {
                    entity.setTenantCode(TenantUtils.getTenantCode());
                }
            }
        }
        if (parameter instanceof com.bizunited.nebula.common.entity.TenantOpEntity) {
            com.bizunited.nebula.common.entity.TenantOpEntity entity = (com.bizunited.nebula.common.entity.TenantOpEntity) parameter;
            if (SqlCommandType.INSERT.equals(statement.getSqlCommandType())) {
                if (Objects.isNull(entity.getTenantCode())) {
                    entity.setTenantCode(TenantUtils.getTenantCode());
                }
            }
        }
        if (parameter instanceof TenantFlagOpEntity) {
            TenantFlagOpEntity entity = (TenantFlagOpEntity) parameter;
            if (SqlCommandType.INSERT.equals(statement.getSqlCommandType())) {
                if (Objects.isNull(entity.getTenantCode())) {
                    entity.setTenantCode(TenantUtils.getTenantCode());
                }
            }
        }
        if (parameter instanceof TenantEntity) {
            TenantEntity entity = (TenantEntity) parameter;
            if (SqlCommandType.INSERT.equals(statement.getSqlCommandType())) {
                if (Objects.isNull(entity.getTenantCode())) {
                    entity.setTenantCode(TenantUtils.getTenantCode());
                }
            }
        }
        return invocation.proceed();
    }

    @Override
    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap(target, this);
        }
        return target;
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
