package com.biz.crm.business.common.local.service.internal;

import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author hecheng
 * @description: 树 ruleCode 生成策略控制器
 * @date 2021/10/14 上午10:42
 */
@Component
public class TreeRuleCodeStrategyHolderImpl implements TreeRuleCodeStrategyHolder {

    @Autowired(required = false)
    private List<TreeRuleCodeStrategy> treeRuleCodeStrategys;
    @Qualifier("defaultTreeRuleCodeStrategy")
    @Autowired(required = false)
    private TreeRuleCodeStrategy defaultTreeRuleCodeStrategy;

    @Override
    public TreeRuleCodeStrategy getStrategy(String key) {
        if (!CollectionUtils.isEmpty(this.treeRuleCodeStrategys)) {
            Optional<TreeRuleCodeStrategy> optional = this.treeRuleCodeStrategys.stream().filter(item -> Objects.equals(item.getKey(), key)).findFirst();
            return optional.orElse(this.defaultTreeRuleCodeStrategy);
        } else {
            return this.defaultTreeRuleCodeStrategy;
        }
    }
}
