package com.biz.crm.business.common.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * dto超类：包含了创建人、创建时间、修改人、修改时间
 *
 * @author sunx
 * @date 2021/10/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class UuidCrmOpDto extends UuidDto {

    /**
     * 创建人账号
     */
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 创建人名称
     */
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;

    /**
     * 更新人账号
     */
    @ApiModelProperty(name = "updateAccount", value = "更新人账号")
    private String updateAccount;

    /**
     * 最后更新时间
     */
    @ApiModelProperty(name = "updateDate", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**
     * 修改人名称
     */
    @ApiModelProperty(name = "updateName", value = "修改人名称")
    private String updateName;


    public void setUpdateInfoToNull(){
        this.updateDate = null;
        this.updateAccount = null;
        this.updateName = null;
    }

    public void setCreateInfoNull(){
        this.createDate = null;
        this.createAccount = null;
        this.createName = null;
    }

    public void setAllInfoNull(){
        setCreateInfoNull();
        setUpdateInfoToNull();
    }

}
