package com.biz.crm.business.common.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 业务系统枚举
 *
 * @author pengxi
 * @date 2022/05/10
 */
@Getter
@AllArgsConstructor
public enum LoginFromTypeEnum {
    /**
     * 业务系统枚举
     */
    CONSOLE(1, "console","后台"),
    DMS_WEB(2, "dms_web","DMS商城"),
    DMS_MINI(3, "dms_mini","DMS微信小程序"),
    SFA_MINI(4, "sfa_mini","SFA微信小程序"),
    SFA_H5(5, "sfa_h5","SFAH5页面"),
    ;
    /**
     * 业务系统类型（对应网关）
     */
    private int appType;
    /**
     * 业务系统值
     */
    private String value;
    /**
     * 业务系统描述
     */
    private String desc;

    public static LoginFromTypeEnum getEnumByAppType(int appType) {
        for (LoginFromTypeEnum item : LoginFromTypeEnum.values()) {
            if (appType==item.getAppType()) {
                return item;
            }
        }
        return null;
    }

    public static LoginFromTypeEnum getEnumByValue(String value) {
        if (value == null) {
            return null;
        }
        for (LoginFromTypeEnum item : LoginFromTypeEnum.values()) {
            if (value.equals(item.getValue())) {
                return item;
            }
        }
        return null;
    }
}
