package com.biz.crm.business.common.sdk.model;

import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;

/**
 * 只要是CRM体系中某个boot所针对的主要登录者身份，都需要继承该类。</p>
 * <p>
 * 目前来看，IdentityType属性通过以下标识区分不同的登录者身份：</br>
 * u-企业用户，c-客户用户，terminal-终端用户，customer_employee-经销商员工用户</br>
 * 但是，怎么来具体使用IdentityType，还要看具体的boot启动器的支持
 *
 * @author hefan yinwenjie
 * @date 2022/04/21
 */
@Getter
@Setter
public abstract class AbstractCrmUserIdentity implements UserIdentity {


    private static final long serialVersionUID = 5898916006465569192L;

    @ApiModelProperty(value = "当前用户身份认证时，所使用的登录方式")
    private Integer loginType;

    @ApiModelProperty(value = "业务系统类型")
    private Integer appType;

    @ApiModelProperty(value = "真实姓名")
    private String realName;

    @ApiModelProperty(value = "用户ID")
    private String userId;

    @ApiModelProperty(value = "可能的用户名，可能没有")
    private String username;

    @ApiModelProperty(value = "可能的密码信息，可能没有")
    private String password;

    @ApiModelProperty(value = "角色编码列表")
    private String[] roleCodes;

    @ApiModelProperty(value = "租户编码")
    private String tenantCode;

    @ApiModelProperty(value = "当前用户身份的类型")
    private String identityType;

    @ApiModelProperty(value = "用户账号")
    private String account;

    @ApiModelProperty(value = "用户手机号")
    private String mobile;

    @ApiModelProperty(value = "用户微信openid")
    private String openId;

    @ApiModelProperty(value = "用户微信openCode")
    private String openCode;

    /**
     * 岗位ID
     *
     * @return {@link String}
     */
    public abstract String getPostId();

    /**
     * 岗位编码
     *
     * @return {@link String}
     */

    public abstract String getPostCode();

    /**
     * 岗位名称
     *
     * @return {@link String}
     */
    public abstract String getPostName();

    /**
     * 通过该方法，系统将向程序员返回某种抽象的用户身份信息中，是否包括了某个字段信息
     *
     * @param fieldName
     * @return true：当前用户身份中，包括了指定的字段；其他值：没有包括指定的字段；
     */
    public Boolean hasField(String fieldName) {
        if (StringUtils.isBlank(fieldName)) {
            return false;
        }
        try {
            this.getClass().getDeclaredField(fieldName);
        } catch (NoSuchFieldException | SecurityException e) {
            // 这里的异常抛不抛出都无所谓
            return false;
        }
        return true;
    }

    /**
     * 通过该方法，系统可以向程序员返回某种抽象的用户身份信息中，指定字段的值（前提是，要有这个字段）
     *
     * @param fieldName
     * @return
     */
    public Object invokeFieldValue(String fieldName) {
        if (StringUtils.isBlank(fieldName)) {
            return false;
        }
        try {
            Class<?> currentClass = this.getClass();
            Field field = currentClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(this);
        } catch (NoSuchFieldException | IllegalAccessException | SecurityException e) {
            // 这里的异常抛不抛出都无所谓
            return null;
        }
    }
}
