package com.biz.crm.business.common.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.bizunited.nebula.security.sdk.AuthenticationUserService;

/**
 * 登录用户相关服务
 *
 * @author pengxi yinwenjie
 * @date 2021-07-27
 */
public interface LoginUserService extends AuthenticationUserService {

    /**
     * 得到抽象登录用户,是本系统登录用户都会继承的对象
     *
     * @return {@link com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity}
     */
    AbstractCrmUserIdentity getAbstractLoginUser();

    /**
     * 获取登录用户，并将登录信息转成json对象
     *
     * @return {@link JSONObject}
     */
    JSONObject getLoginUserJson();
}
