package com.biz.crm.business.common.sdk.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;

/**
 * @author HanJiaJun
 * @describe: 脱敏工具类 只写了目前需要的
 * @createTime 2023年12月08日 10:17:00
 */

@Slf4j
public class DesensitizationUtil {

  private DesensitizationUtil() {
    throw new IllegalStateException("静态工具类不能实例化");
  }

  /**
   * 脱敏字符串，只保留第一位和最后一位，中间进行脱敏
   *
   * @param str     原字符串
   * @param replace 替换字符
   * @param copy    替换字符复制几遍
   *                例如  需要将'12345' 只保留第一位和最后一位，中间用*来替换，并且最终长度是10位
   *                结果：1********5，传入参数（"12345","**",4）
   * @return
   */
  public static String replaceFirstAndLastStr(String str, String replace, int copy) {
    Validate.notBlank(str, "脱敏中原始字符串不能为空!");
    Validate.notBlank(str, "脱敏中替换字符不能为空!");
    Validate.notNull(copy, "脱敏中替换字符复制次数不能为空!");
    char start = str.charAt(0);
    char end = str.charAt(str.length() - 1);
    StringBuilder character = new StringBuilder();
    for (int i = 0; i < copy; i++) {
      character.append(replace);
    }
    StringBuilder result = new StringBuilder();
    result.append(start).append(character).append(end);
    return result.toString();
  }
}
