package com.biz.crm.business.common.sdk.utils;

import java.math.BigDecimal;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 通过地图上的两个坐标计算距离
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class DistanceUtil {

  /**
   * 计算两个坐标点之间的距离
   *
   * @param lat1 第一个坐标的纬度
   * @param lng1 第一个坐标的经度
   * @param lat2 第二个坐标的纬度
   * @param lng2 第二个坐标的经度
   * @return 返回两点之间的距离，单位：米
   */
  public static double calculatePointDistance(BigDecimal lat1, BigDecimal lng1, BigDecimal lat2, BigDecimal lng2) {
    return calculatePointDistance(lat1.doubleValue(), lng1.doubleValue(),
        lat2.doubleValue(), lng2.doubleValue());
  }

  /**
   * 计算两个坐标点之间的距离 Add by 成长的小猪（Jason.Song） on 2017/11/01 http://blog.csdn.net/jasonsong2008
   *
   * @param lat1 第一个坐标的纬度
   * @param lng1 第一个坐标的经度
   * @param lat2 第二个坐标的纬度
   * @param lng2 第二个坐标的经度
   * @return 返回两点之间的距离，单位：米
   */
  public static double calculatePointDistance(double lat1, double lng1, double lat2, double lng2) {
    return GpsLocationUtil.calculatePointDistance(lat1, lng1, lat2, lng2);
  }

  /**
   * 计算两点之间的距离，并和最后的距离进行验证
   * 
   * @param lat1 第一个坐标的纬度
   * @param lng1 第一个坐标的经度
   * @param lat2 第二个坐标的纬度
   * @param lng2 第二个坐标的经度
   * @param maxDistance 最大距离
   * @return -1 小于最大距离的和，0：等于最大距离的和 1 大于最大距离的和
   */
  public static int comparePointDistance(BigDecimal lat1, BigDecimal lng1, BigDecimal lat2, BigDecimal lng2,
      Integer... maxDistance) {
    return comparePointDistance(lat1.doubleValue(), lng1.doubleValue(),
        lat2.doubleValue(), lng2.doubleValue(), maxDistance);
  }

  /**
   * 计算两点之间的距离，并和最后的距离进行验证
   * 
   * @param lat1 第一个坐标的纬度
   * @param lng1 第一个坐标的经度
   * @param lat2 第二个坐标的纬度
   * @param lng2 第二个坐标的经度
   * @param maxDistance 最大距离
   * @return -1 小于最大距离的和，0：等于最大距离的和 1 大于最大距离的和
   */
  public static int comparePointDistance(double lat1, double lng1, double lat2, double lng2,
      Integer... maxDistance) {
    int maxDistanceValue = 0;
    for (Integer distance : maxDistance) {
      if (distance != null) {
        maxDistanceValue += distance;
      }
    }
    double calculatePointDistance = calculatePointDistance(lat1, lng1, lat2, lng2);
    int compareTo = BigDecimal.valueOf(calculatePointDistance).compareTo(BigDecimal.valueOf(maxDistanceValue));
    return compareTo;
  }
}
