package com.biz.crm.business.common.sdk.utils;

import lombok.extern.slf4j.Slf4j;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GlobalCoordinates;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * GPS定位工具类
 * 
 * @author xzkne
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
@Slf4j
public class GpsLocationUtil {
  /**
   * 计算两个坐标点之间的距离
   *
   * @param lat1 第一个坐标的纬度
   * @param lng1 第一个坐标的经度
   * @param lat2 第二个坐标的纬度
   * @param lng2 第二个坐标的经度
   * @return 返回两点之间的距离，单位：米
   */
  public static double calculatePointDistance(double lat1, double lng1, double lat2, double lng2) {
    // 创建两个点的GlobalCoordinates对象
    GlobalCoordinates point1 = new GlobalCoordinates(lat1, lng1);
    GlobalCoordinates point2 = new GlobalCoordinates(lat2, lng2);
    // 创建GeodeticCalculator对象并将椭球体设置为WGS84
    GeodeticCalculator calculator = new GeodeticCalculator();
    // 使用GeodeticCalculator对象计算两点之间的距离
    double ellipsoidalDistance =
        calculator.calculateGeodeticCurve(Ellipsoid.WGS84, point1, point2).getEllipsoidalDistance();
    return ellipsoidalDistance;
  }

  public static void main(String[] args) {
    double lat1 = 30.64242;
    double lon1 = 104.04311;
    double lat2 = 30.64136211;
    double lon2 = 104.03996944;
    double distance = GpsLocationUtil.calculatePointDistance(lat1, lon1, lat2, lon2);
    log.info("两点之间的距离为：" + distance + " 米");
    log.info(
        "验证地址：https://lbs.amap.com/demo/javascript-api/example/calcutation/calculate-distance-between-two-markers");
  }
}
