package com.biz.crm.business.common.sdk.utils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class HttpServletRequestUtil {
  public HttpServletRequestUtil() {
  }

  public static HttpServletRequest getRequest() {
    HttpServletRequest request = null;
    ServletRequestAttributes servletRequestAttributes = null;
    RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
    if (requestAttributes != null) {
      servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
      request = servletRequestAttributes.getRequest();
    }

    return request;
  }

  public static HttpServletResponse getResponse() {
    HttpServletResponse response = null;
    ServletRequestAttributes servletRequestAttributes = null;
    RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
    if (requestAttributes != null) {
      servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
      response = servletRequestAttributes.getResponse();
    }

    return response;
  }

  public static void writeResponseFile(byte[] result, String fileName) {
    writeResponseFile(getRequest(), getResponse(), result, fileName);
  }

  public static void writeResponseFile(HttpServletRequest request, HttpServletResponse response, byte[] result, String fileName) {
    String currentFileName;
    try {
      if (StringUtils.isBlank(fileName)) {
        currentFileName = "temp";
      } else {
        currentFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
      }
    } catch (UnsupportedEncodingException var9) {
      //log.error(var9.getMessage(), var9);
      currentFileName = "temp";
    }

    response.setContentType("application/octet-stream;charset=utf-8");
    response.addHeader("Content-Disposition", "attachment;fileName=" + encodeFileName(request, currentFileName));

    try (OutputStream out = response.getOutputStream()){
      out.write(result);
    } catch (IOException var8) {
      //log.error(var8.getMessage(), var8);
      throw new IllegalArgumentException(var8.getMessage(), var8);
    } finally {
      response.reset();
    }
  }

  private static String encodeFileName(HttpServletRequest request, String fileName) {
    String agent = request.getHeader("User-Agent");
    if (StringUtils.isBlank(agent)) {
      try {
        return URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
      } catch (UnsupportedEncodingException var6) {
        //log.warn(var6.getMessage(), var6);
      }
    }

    if (!agent.contains("Firefox") && !agent.contains("Safari")) {
      if (agent.contains("Chrome")) {
        try {
          fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        } catch (UnsupportedEncodingException var5) {
          //log.warn(var5.getMessage(), var5);
        }
      }
    } else {
      fileName = new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
    }

    return fileName;
  }

}