package com.biz.crm.business.common.sdk.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * @className: com.biz.crm.business.common.sdk.utils.StringCheckUtuls
 * @description: 字符串校验工具类
 * @author: xiaopeng.zhang
 * @create: 2025-01-09 9:28
 */
public class StringCheckUtils {


    /**
     * 字符串相似度匹配 返回值 0到1
     *
     * @param str1
     * @param str2
     * @return
     */
    public static double computeSimilarity(String str1, String str2) {

//        Validate.notBlank(str1, "比较字符串不能为空");
//        Validate.notBlank(str2, "比较字符串不能为空");
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return 0d;
        }

        int len1 = str1.length();
        int len2 = str2.length();

        // 创建一个二维数组来保存中间结果
        int[][] matrix = new int[len1 + 1][len2 + 1];

        // 初始化边界条件
        for (int i = 0; i <= len1; i++) {
            matrix[i][0] = i;
        }
        for (int j = 0; j <= len2; j++) {
            matrix[0][j] = j;
        }

        // 计算两个字符串的Levenshtein距离
        for (int i = 1; i <= len1; i++) {
            char char1 = str1.charAt(i - 1);
            for (int j = 1; j <= len2; j++) {
                char char2 = str2.charAt(j - 1);
                if (char1 == char2) {
                    matrix[i][j] = matrix[i - 1][j - 1];
                } else {
                    matrix[i][j] = 1 + Math.min(matrix[i - 1][j - 1], Math.min(matrix[i][j - 1], matrix[i - 1][j]));
                }
            }
        }

        // 计算相似度
        return 1 - ((double) matrix[len1][len2] / Math.max(str1.length(), str2.length()));
    }
}
