package com.biz.crm.business.common.sdk.utils;
/**
 * Created by Bao Hongbin on 2021-10-28 18:24.
 */

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description: 树工具类
 * @author: Bao Hongbin
 * @create: 2021-10-28 18:24
 **/
public class TreeUtil {
  /**
   * 构建树形结构
   *
   * @param totalList
   * @return
   */
  public static List<TreeVo> generateTreeByParentCode(List<TreeVo> totalList) {
    //构建树list
    List<TreeVo> treeList = new ArrayList<>();
    //当前操作层级数据
    List<TreeVo> curLevelList = new ArrayList<>();
    //未操作数据
    List<TreeVo> restList = new ArrayList<>();
    //key:id
    Map<String, TreeVo> totalMap = totalList.stream().collect(Collectors.toMap(TreeVo::getCode, v -> v));
    //查找第一层
    for (TreeVo item :
        totalList) {
      if (StringUtils.isEmpty(item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
        treeList.add(item);
        curLevelList.add(item);
      } else {
        restList.add(item);
      }
    }
    //构建数据，从第二层开始
    while (CollectionUtil.isNotEmpty(curLevelList) && CollectionUtil.isNotEmpty(restList)) {
      List<TreeVo> restTempList = new ArrayList<>();
      List<TreeVo> curLevelTempList = new ArrayList<>();
      Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(TreeVo::getCode, TreeVo::getCode, (v1, v2) -> v1));
      Map<String, List<TreeVo>> curLevelChildrenMap = new HashMap<>();
      for (TreeVo item :
          restList) {
        if (curLevelMap.containsKey(item.getParentCode())) {
          curLevelTempList.add(item);

          List<TreeVo> childrenList = new ArrayList<>();
          if (curLevelChildrenMap.containsKey(item.getParentCode())) {
            childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
          }
          childrenList.add(item);
          curLevelChildrenMap.put(item.getParentCode(), childrenList);
        } else {
          restTempList.add(item);
        }
      }
      for (TreeVo item :
          curLevelList) {
        if (curLevelChildrenMap.containsKey(item.getCode())) {
          item.setChildren(curLevelChildrenMap.get(item.getCode()));
        }
      }
      curLevelList.clear();
      curLevelList.addAll(curLevelTempList);
      restList.clear();
      restList.addAll(restTempList);
    }
    return treeList;
  }

  /**
   * 从树形结构中移除某个节点
   *
   * @param tree                   树
   * @param excludeCodeAncChildren 需要移除的编码
   */
  public static void excludeCodeAndChildren(List<TreeVo> tree, String excludeCodeAncChildren) {
    if (!CollectionUtils.isEmpty(tree) && StringUtils.isNotEmpty(excludeCodeAncChildren)) {
      Iterator<TreeVo> iterator = tree.iterator();
      while (iterator.hasNext()) {
        TreeVo item = iterator.next();
        if (item.getCode().equals(excludeCodeAncChildren)) {
          iterator.remove();
          return;
        }
        excludeCodeAndChildren(item.getChildren(), excludeCodeAncChildren);
      }
    }
  }

  /**
   * 构建懒加载树形结构
   * @param totalList
   * @return
   */
  public static List<LazyTreeVo> generateLazyTreeByParentCode(List<LazyTreeVo> totalList) {
    //构建树list
    List<LazyTreeVo> treeList = new ArrayList<>();
    //当前操作层级数据
    List<LazyTreeVo> curLevelList = new ArrayList<>();
    //未操作数据
    List<LazyTreeVo> restList = new ArrayList<>();
    //key:id
    Map<String, LazyTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(LazyTreeVo::getCode, v -> v));
    //查找第一层
    for (LazyTreeVo item :
        totalList) {
      if (!StringUtils.isNotEmpty(item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
        treeList.add(item);
        curLevelList.add(item);
      } else {
        restList.add(item);
      }
    }
    //构建数据，从第二层开始
    while (CollectionUtil.isNotEmpty(curLevelList)&& CollectionUtil.isNotEmpty(restList)) {
      List<LazyTreeVo> restTempList = new ArrayList<>();
      List<LazyTreeVo> curLevelTempList = new ArrayList<>();
      Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(LazyTreeVo::getCode, LazyTreeVo::getCode, (v1, v2) -> v1));
      Map<String, List<LazyTreeVo>> curLevelChildrenMap = new HashMap<>();
      for (LazyTreeVo item :
          restList) {
        if (curLevelMap.containsKey(item.getParentCode())) {
          curLevelTempList.add(item);

          List<LazyTreeVo> childrenList = new ArrayList<>();
          if (curLevelChildrenMap.containsKey(item.getParentCode())) {
            childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
          }
          childrenList.add(item);
          curLevelChildrenMap.put(item.getParentCode(), childrenList);
        } else {
          restTempList.add(item);
        }
      }
      for (LazyTreeVo item :
          curLevelList) {
        if (curLevelChildrenMap.containsKey(item.getCode())) {
          item.setChildren(curLevelChildrenMap.get(item.getCode()));
        }
      }
      curLevelList.clear();
      curLevelList.addAll(curLevelTempList);
      restList.clear();
      restList.addAll(restTempList);
    }
    return treeList;
  }
}
